package gov.va.med.mhv.getcare.web.util;

import java.util.Locale;

import javax.faces.context.FacesContext;

import org.primefaces.component.datatable.DataTable;
import org.primefaces.model.SortOrder;

public class FacesUtil {
	
	public static Boolean getSortColumnAscending(String dataTableId) {
		try {
			DataTable dataTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent(dataTableId);
			SortOrder sortOrder = SortOrder.valueOf(dataTable.getSortOrder().toUpperCase(Locale.ENGLISH));
			boolean asc = sortOrder.equals(SortOrder.ASCENDING);
			
			return asc;
		} catch (Exception e) {
		}
		return null;
	}

	public static String getSortColumnField(String dataTableId) {
		try {
			DataTable dataTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent(dataTableId);
			return dataTable.getSortColumn().getField();	
		} catch (Exception e) {
		}
		return null;
	}
}
